
rm(list=ls())
X = read.csv(file = "Scaricati/NFWBS_PUF_2016_data.csv",header = TRUE)
source("/home/antonio/MEGA/Lavoro_sync/Didattica/2022_2023/testing_psicologico/laboratorio/utilities/utilities.R")

finance = X[X$sample==1,grep(x = colnames(X),pattern = "FW|PPGENDER"),]
str(finance)
#save(finance,file = "Scaricati/finance.Rdata")

#1
pp = 0.30
out = split_dataset(data = finance,prop = pp,seedx = 90210)
finance_train = out$A
finance_test = out$B
dim(finance_train)
dim(finance_test)

#2
#x11(); corrplot::corrplot(corr = cor(finance_train[,2:11],method = "spearman"),order = "hclust",hclust.method = "ward.D2",addrect=2)
D = dist(cor(finance_train[,2:11],method = "spearman"))
hc = hclust(d = D,method = "ward.D2")
#x11(); plot(hc)
mod_def = hclust2lavaan(tree = hc,ngroups = 2)

for(j in 2:11){finance_test[,j] = factor(finance_test[,j],ordered = TRUE)}
finance$PPGENDER = as.character(finance$PPGENDER)

#psycModel::measurement_invariance(data = finance,model = mod_def,group = "PPGENDER",invariance_level = "metric")


#2 (configural) configurale
mod_fit0 = cfa(model = mod_def,data = finance_train,ordered = colnames(finance_test)[2:11],estimator="DWLS",group = "PPGENDER",std.lv=TRUE)

#3 (metric) debole
mod_fit1 = cfa(model = mod_def,data = finance_train,ordered = colnames(finance_test)[2:11],estimator="DWLS",group = "PPGENDER",
               group.equal=c("loadings"),std.lv=TRUE)
anova(mod_fit1,mod_fit0)

evaluate_partial_invariance(fitted_model = mod_fit1,type = "metric")
mod_fit1a = cfa(model = mod_def,data = finance_train,ordered = colnames(finance_test)[2:11],estimator="DWLS",group = "PPGENDER",
               group.equal=c("loadings"),group.partial=c("eta1 =~ FWB1_4","eta2 =~ FWB1_3","eta2 =~ FWB1_6"),std.lv=TRUE)
anova(mod_fit1a,mod_fit0)


#4 (scalar) forte
mod_fit2 = cfa(model = mod_def,data = finance_train,ordered = colnames(finance_test)[2:11],estimator="DWLS",group = "PPGENDER",
               group.equal=c("loadings","intercepts"),group.partial=c("eta1 =~ FWB1_4","eta2 =~ FWB1_3","eta2 =~ FWB1_6"),std.lv=TRUE)
anova(mod_fit2,mod_fit1a)

#
## study differences in terms of means
summary_table(fitted_model = mod_fit2,type_summary = "intercept")

x11();plot_lavaan_model(fitted_model = mod_fit2,what = "std",intercepts=FALSE,panelGroups = TRUE,thresholds=FALSE,style = "openmx")




