###########################################################################
### PSQ4106864 DATAVIS
### A.Y. 2024/2025
### prof. Antonio Calcagni' (antonio.calcagni@unipd.it)
###########################################################################


### CONTENTS ###########################################
## (A) Layouts
## (B) Export plots
########################################################


# Set environment ---------------------------------------------------------
rm(list=ls())
setwd("/home/antonio/MEGA/Lavoro_sync/Didattica/2024_2025/datavis/")

## Data import
datax <- read.csv(file <- "datasets/data_anxiety.csv",header <- TRUE,sep <- ",",) 
str(datax)



# (A) Layouts -------------------------------------------------------------

## In the following examples, we will be learning how to add more than one plot on a graphical window.
## As usual, the step-by-step approach is quite helpful to organize the graphical elements in this case.

## Suppose, we are interesting in plotting 'anxiety_score' (y1) and 'income' (y2) as a function of 'gender' onto the same window.
## To start with, consider the following working variables:

y1min <- min(datax$anxiety_score)
y1max <- max(datax$anxiety_score)

y2min <- min(datax$income) #min y-axis
y2max <- max(datax$income) #max y-axis

x <- 1:nrow(datax) #the x-axis is the same for both plots here
y1 <- datax$anxiety_score 
y2 <- datax$income

iid_male <- datax$gender=="Male" #indicator variable for the first group
iid_female <- datax$gender=="Female" #indicator variable for the first group
col_male <- "#A52A2A" #color for the first group 
col_female <- "#66CD00" #color for the second group

x11()
par(mfrow=c(1,2)) #it splits the graphical window into two sub-windows (1x2 matrix)
# first subplot
plot(0,0,xlim=c(min(x),max(x)),ylim=c(y1min,y1max),bty="n",xlab="",ylab="anxiety")
points(x[iid_male],y1[iid_male],col=col_male,pch=20,cex=1.25) 
points(x[iid_female],y1[iid_female],col=col_female,pch=20,cex=1.25)
title(main = "Anxiety",cex.main=1.35,line=0,adj=0) 
# second subplot
plot(0,0,xlim=c(min(x),max(x)),ylim=c(y2min,y2max),bty="n",xlab="",ylab="income")
points(x[iid_male],y2[iid_male],col=col_male,pch=20,cex=1.25) 
points(x[iid_female],y2[iid_female],col=col_female,pch=20,cex=1.25)
title(main = "Income",cex.main=1.35,line=0,adj=0) 

x11()
par(mfcol=c(2,2)) #it splits the graphical window into four sub-windows (2x2 matrix) --note mfcol populates the window column-by-column
# first subplot
plot(0,0,xlim=c(min(x),max(x)),ylim=c(y1min,y1max),bty="n",xlab="",ylab="anxiety")
points(x[iid_male],y1[iid_male],col=col_male,pch=20,cex=1.25) 
points(x[iid_female],y1[iid_female],col=col_female,pch=20,cex=1.25)
title(main = "Anxiety",cex.main=1.35,line=0,adj=0) 
# second subplot
plot(0,0,xlim=c(min(x),max(x)),ylim=c(y2min,y2max),bty="n",xlab="",ylab="income")
points(x[iid_male],y2[iid_male],col=col_male,pch=20,cex=1.25) 
points(x[iid_female],y2[iid_female],col=col_female,pch=20,cex=1.25)
title(main = "Income",cex.main=1.35,line=0,adj=0) 
# third subplot
plot(y1[iid_male],y2[iid_male],bty="n",xlab="anxiety",ylab="income",pch=20)
title(main = "Male",cex.main=1.35,line=0,adj=0) 
# fourth subplot
plot(y1[iid_female],y2[iid_female],bty="n",xlab="anxiety",ylab="income",pch=20)
title(main = "Female",cex.main=1.35,line=0,adj=0) 


## More complex scenarios can be handled using the layout() function instead of par(), as follows:
x11()
layout(mat = matrix(c(1,2,3,4),2,2),widths = c(2,2),heights = c(2,2),respect = TRUE)
# 'mat' specifies the location of the next N figures on the output device
# 'widths' controls for the widths of columns
# 'heights' controls for the heights of columns
# 'respect' controls for the measurement unit to be the same over the subplots

# first subplot
plot(0,0,xlim=c(min(x),max(x)),ylim=c(y1min,y1max),bty="n",xlab="",ylab="anxiety")
points(x[iid_male],y1[iid_male],col=col_male,pch=20,cex=1.25) 
points(x[iid_female],y1[iid_female],col=col_female,pch=20,cex=1.25)
title(main = "Anxiety",cex.main=1.35,line=0,adj=0) 
# second subplot
plot(0,0,xlim=c(min(x),max(x)),ylim=c(y2min,y2max),bty="n",xlab="",ylab="income")
points(x[iid_male],y2[iid_male],col=col_male,pch=20,cex=1.25) 
points(x[iid_female],y2[iid_female],col=col_female,pch=20,cex=1.25)
title(main = "Income",cex.main=1.35,line=0,adj=0) 
# third subplot
plot(y1[iid_male],y2[iid_male],bty="n",xlab="anxiety",ylab="income",pch=20)
title(main = "Male",cex.main=1.35,line=0,adj=0) 
# fourth subplot
plot(y1[iid_female],y2[iid_female],bty="n",xlab="anxiety",ylab="income",pch=20)
title(main = "Female",cex.main=1.35,line=0,adj=0) 

# ..play around with the graphical parameters
x11()
layout(mat = matrix(c(3,1,2,4),2,2),widths = c(2,4),heights = c(3,3),respect = TRUE)
# first subplot
plot(0,0,xlim=c(min(x),max(x)),ylim=c(y1min,y1max),bty="n",xlab="",ylab="anxiety")
points(x[iid_male],y1[iid_male],col=col_male,pch=20,cex=1.25) 
points(x[iid_female],y1[iid_female],col=col_female,pch=20,cex=1.25)
title(main = "Anxiety",cex.main=1.35,line=0,adj=0) 
# second subplot
plot(0,0,xlim=c(min(x),max(x)),ylim=c(y2min,y2max),bty="n",xlab="",ylab="income")
points(x[iid_male],y2[iid_male],col=col_male,pch=20,cex=1.25) 
points(x[iid_female],y2[iid_female],col=col_female,pch=20,cex=1.25)
title(main = "Income",cex.main=1.35,line=0,adj=0) 
# third subplot
plot(y1[iid_male],y2[iid_male],bty="n",xlab="anxiety",ylab="income",pch=20)
title(main = "Male",cex.main=1.35,line=0,adj=0) 
# fourth subplot
plot(y1[iid_female],y2[iid_female],bty="n",xlab="anxiety",ylab="income",pch=20)
title(main = "Female",cex.main=1.35,line=0,adj=0) 

# ..another case
x11()
layout(matrix(c(1, 2, 1, 3), ncol=2))
# first subplot 
plot(y1[iid_male],y2[iid_male],bty="n",xlab="anxiety",ylab="income",pch=2)
points(y1[iid_female],y2[iid_female],bty="n",xlab="anxiety",ylab="income",pch=3)
# second subplot
plot(y1[iid_male],y2[iid_male],bty="n",xlab="anxiety",ylab="income",pch=20,col="gray")
title(main = "Male",cex.main=1.35,line=0,adj=0) 
# fourth subplot
plot(y1[iid_female],y2[iid_female],bty="n",xlab="anxiety",ylab="income",pch=20,col="gray")
title(main = "Female",cex.main=1.35,line=0,adj=0) 


## More complex cases can be solved using advanced plotting features powered by layout() coupled with other R functions.
## For further information, see: https://www.benjaminbell.co.uk/2018/02/creating-multi-panel-plots-and-figures.html



# (B) Export plots --------------------------------------------------------

## Once created, plots can be exported in different formats.

## PDF
cairo_pdf(filename = "figure1.pdf",width = 9,height = 6) #in this case, no x11() or quartz() is needed as the graphical window is managed by cairo 
layout(matrix(c(1, 2, 1, 3), ncol=2))
# first subplot 
plot(y1[iid_male],y2[iid_male],bty="n",xlab="anxiety",ylab="income",pch=2)
points(y1[iid_female],y2[iid_female],bty="n",xlab="anxiety",ylab="income",pch=3)
# second subplot
plot(y1[iid_male],y2[iid_male],bty="n",xlab="anxiety",ylab="income",pch=20,col="gray")
title(main = "Male",cex.main=1.35,line=0,adj=0) 
# fourth subplot
plot(y1[iid_female],y2[iid_female],bty="n",xlab="anxiety",ylab="income",pch=20,col="gray")
title(main = "Female",cex.main=1.35,line=0,adj=0) 
# print the figure
dev.off() 


## JPEG
jpeg(filename = "figure1.jpg",width = 500,height = 600) #in this case, no x11() or quartz() is needed as the graphical window is managed by cairo 
layout(matrix(c(1, 2, 1, 3), ncol=2))
# first subplot 
plot(y1[iid_male],y2[iid_male],bty="n",xlab="anxiety",ylab="income",pch=2)
points(y1[iid_female],y2[iid_female],bty="n",xlab="anxiety",ylab="income",pch=3)
# second subplot
plot(y1[iid_male],y2[iid_male],bty="n",xlab="anxiety",ylab="income",pch=20,col="gray")
title(main = "Male",cex.main=1.35,line=0,adj=0) 
# fourth subplot
plot(y1[iid_female],y2[iid_female],bty="n",xlab="anxiety",ylab="income",pch=20,col="gray")
title(main = "Female",cex.main=1.35,line=0,adj=0) 
# print the figure
dev.off() 


## PNG
png(filename = "figure1.png",width = 500,height = 600) #in this case, no x11() or quartz() is needed as the graphical window is managed by cairo 
layout(matrix(c(1, 2, 1, 3), ncol=2))
# first subplot 
plot(y1[iid_male],y2[iid_male],bty="n",xlab="anxiety",ylab="income",pch=2)
points(y1[iid_female],y2[iid_female],bty="n",xlab="anxiety",ylab="income",pch=3)
# second subplot
plot(y1[iid_male],y2[iid_male],bty="n",xlab="anxiety",ylab="income",pch=20,col="gray")
title(main = "Male",cex.main=1.35,line=0,adj=0) 
# fourth subplot
plot(y1[iid_female],y2[iid_female],bty="n",xlab="anxiety",ylab="income",pch=20,col="gray")
title(main = "Female",cex.main=1.35,line=0,adj=0) 
# print the figure
dev.off() 
