generate_color_gradient <- function(values, colors = c("blue", "white", "red")) {
  # Create a vector to store colors
  color_output <- rep("white", length(values))  # Default color for NA
  
  # Identify non-NA values
  valid_values <- !is.na(values)
  
  if (any(valid_values)) {
    # Normalize valid values between 0 and 1
    min_val <- min(values[valid_values], na.rm = TRUE)
    max_val <- max(values[valid_values], na.rm = TRUE)
    normalized_values <- (values[valid_values] - min_val) / (max_val - min_val)
    
    # Create color palette function
    palette_func <- colorRampPalette(colors)
    
    # Generate colors based on normalized values
    gradient_colors <- palette_func(100)[as.numeric(cut(normalized_values, breaks = 100))]
    
    # Assign colors to valid values
    color_output[valid_values] <- gradient_colors
  }
  
  return(color_output)
}
