## https://cran.r-project.org/web/packages/paramtest/vignettes/Simulating-Power.html

rm(list=ls()); graphics.off()


# Simple Normal linear model ----------------------------------------------
set.seed(221212)
alpha = 0.05
b0 = 0
b1 = 0.25 #b1 in [0,1]
sdy = sqrt(1-b1^2)
#sdy = 3.9 #alternative setting for the variance of the model if b1 not in [0,1]
N = c(25,50,100,250,500)
B = 2500 #number of replications
Pwr = matrix(NA,length(N),B)
for(k in 1:length(N)){
  for(b in 1:B){
    x = rbinom(N[k],1,0.5) #generating categorical predictor
    x = factor(x,labels = c("A","B"))
    X = model.matrix(~x)
    y = X%*%c(b0,b1) + rnorm(N[k],0,sdy)
    out = lm(y~x)
    pb = summary(out)$coefficients[2,4]
    Pwr[k,b] = ifelse(pb<alpha,1,0)
  }
}
pwr = apply(Pwr,1,mean)
x11();plot(N,pwr,type="b",lty=2,bty="n",ylim=c(0,1)); abline(h = 0.80,lty=2,col=2)


# Normal linear model with interactions -----------------------------------
set.seed(221212)
alpha = 0.05
b0 = 0
b1 = 0.25 #b in [0,1]
b2 = 0.08 #b in [0,1]
b12 = 0.66 #b in [0,1]
sdy = sqrt(1-b1^2-b2^2-b12^2)
#sdy = 3.9 #alternative setting for the variance of the model if b not in [0,1]
N = c(25,50,100,250,500)
B = 2500 #number of replications
Pwr1 = matrix(NA,length(N),B)
Pwr2 = matrix(NA,length(N),B)
Pwr3 = matrix(NA,length(N),B)
Pwr4 = matrix(NA,length(N),B) 
for(k in 1:length(N)){
  for(b in 1:B){
    x = rbinom(N[k],1,0.5) #generating categorical predictor
    x1 = factor(x,labels = c("A","B"))
    x2 = runif(N[k],-1,1); x2 = (x2-mean(x2))/sd(x2)
    X = model.matrix(~x1+x2+x1:x2)
    y = X%*%c(b0,b1,b2,b12) + rnorm(N[k],0,sdy)
    out = lm(y~x1+x2+x1:x2)
    pb1 = summary(out)$coefficients[2,4]
    pb2 = summary(out)$coefficients[3,4]
    pb12 = summary(out)$coefficients[4,4]
    Pwr1[k,b] = ifelse(pb1<alpha,1,0)
    Pwr2[k,b] = ifelse(pb2<alpha,1,0)
    Pwr3[k,b] = ifelse(pb12<alpha,1,0)
    pb_all = Pwr1[k,b] + Pwr2[k,b] + Pwr3[k,b]
    Pwr4[k,b] = ifelse(pb_all==3,1,0)
  }
}
pwr1 = apply(Pwr1,1,mean)
pwr2 = apply(Pwr2,1,mean)
pwr12 = apply(Pwr3,1,mean)
pwr_all = apply(Pwr4,1,mean)

x11()
plot(N,pwr1,type="b",lty=2,bty="n",ylim=c(0,1),xlim=c(min(N)-50,max(N)+50)); abline(h = 0.80,lty=2)
points(N,pwr2,type="b",lty=2,col=2)
points(N,pwr12,type="b",lty=2,col=4)
points(N,pwr_all,type="b",lty=2,col=6)
legend("topleft",lty=2,col = c(1,2,4,6),legend = c("b1","b2","b12","all"))









